/****** Object:  View [dbo].[V_ITEC_SUITE_EST_PROD_SUPRIMENTO_ENTREGA_LOJA_AGRUPADOR]    Script Date: 01/22/2013 09:45:54 ******/
IF EXISTS (SELECT * FROM sys.views
					 WHERE
						object_id = OBJECT_ID(N'[dbo].[V_ITEC_SUITE_EST_PROD_SUPRIMENTO_ENTREGA_LOJA_AGRUPADOR]'))
	DROP VIEW [dbo].[V_ITEC_SUITE_EST_PROD_SUPRIMENTO_ENTREGA_LOJA_AGRUPADOR]

GO
--SELECT * FROM V_ITEC_SUITE_EST_PROD_SUPRIMENTO_ENTREGA_LOJA_AGRUPADOR
CREATE VIEW V_ITEC_SUITE_EST_PROD_SUPRIMENTO_ENTREGA_LOJA_AGRUPADOR AS
SELECT 
	0 TIPO,
	'FABRICANTE' AS DS_TIPO, 
	CD_EMP,
	CD_USU,
	NM_FABRIC AS DESCRICAO,
    SUM(QTDE_PROD) QTDE_PROD,
    SUM(QTDE_PROD * (VLR_PROD - VLR_DESC)) VLR_TOTAL,
    SUM(QTDE_PROD * VLR_DESC) VLR_DESCONTO,
    SUM(COB) COB
    FROM (
      SELECT 
		E.CD_EMP,
		E.CD_USU,
		UPPER(F.NM_FABRIC) NM_FABRIC
            ,E.QTDE_PROD
            ,E.VLR_PROD
            ,E.VLR_PROD * (CASE
            WHEN ISNULL(E.PERC_DESC, 0) > 0 THEN ISNULL(E.PERC_DESC, 0)
            ELSE ISNULL(P.PERC_DESC_FABRICA, 0)
            END ) / 100 as VLR_DESC
            ,ROUND(CASE WHEN COALESCE(E.MEDIAF,0) > 0 THEN
              (E.QT_EST_PEND + E.QTDE_PROD) * 30 / E.MEDIAF
            ELSE
              (E.QT_EST_PEND + E.QTDE_PROD) * 30 / 0.0001
            END, 3) COB

      FROM   EST_PROD_SUPRIMENTO_ENTREGA_LOJA E
          INNER JOIN EST_PROD P
              ON E.CD_EMP = P.CD_EMP
                AND E.CD_PROD = P.CD_PROD
          INNER JOIN EST_PROD_FABRIC F
              ON P.CD_FABRIC = F.CD_FABRIC
    ) T
    GROUP BY 
		NM_FABRIC,		
		CD_EMP,
		CD_USU


    UNION ALL

    SELECT 
		1 TIPO, 
		'LINHA' AS DS_TIPO, 
		CD_EMP,
		CD_USU,
		DS_ARV_MERC_LINHA AS DESCRICAO,
        SUM(QTDE_PROD) QTDE_PROD,
        SUM(QTDE_PROD * (VLR_PROD - VLR_DESC)) VLR_TOTAL,
        SUM(QTDE_PROD * VLR_DESC) VLR_DESCONTO,
        SUM(COB) COB
    FROM (
      SELECT
	  		E.CD_EMP,
			E.CD_USU,
			l.DS_ARV_MERC_LINHA
            ,E.QTDE_PROD
            ,E.VLR_PROD
            ,E.VLR_PROD * (CASE
            WHEN ISNULL(E.PERC_DESC, 0) > 0 THEN ISNULL(E.PERC_DESC, 0)
            ELSE ISNULL(P.PERC_DESC_FABRICA, 0)
            END ) / 100 as VLR_DESC
            ,ROUND(CASE WHEN COALESCE(E.MEDIAF,0) > 0 THEN
              (E.QT_EST_PEND + E.QTDE_PROD) * 30 / E.MEDIAF
            ELSE
              (E.QT_EST_PEND + E.QTDE_PROD) * 30 / 0.0001
            END, 3) COB

      FROM   EST_PROD_SUPRIMENTO_ENTREGA_LOJA E
          INNER JOIN EST_PROD P
              ON E.CD_EMP = P.CD_EMP
                AND E.CD_PROD = P.CD_PROD
          INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA A
              ON P.CD_EMP = A.CD_EMP
                AND P.CD_PROD = A.CD_PROD
          INNER JOIN  EST_ARV_MERC_LINHA l
              ON a.CD_EMP = l.CD_EMP
                AND a.CD_ARV_MERC_LINHA = l.CD_ARV_MERC_LINHA
    ) T
    GROUP BY 
		DS_ARV_MERC_LINHA,
		CD_EMP,
		CD_USU


    UNION ALL

    SELECT 
		2 TIPO, 
		'CURVA' AS DS_TIPO, 
		CD_EMP,
		CD_USU,
		DS_SIGLA AS DESCRICAO,
        SUM(QTDE_PROD) QTDE_PROD,
        SUM(QTDE_PROD * (VLR_PROD - VLR_DESC)) VLR_TOTAL,
        SUM(QTDE_PROD * VLR_DESC) VLR_DESCONTO,
        SUM(COB) COB
    FROM (
      SELECT 
			E.CD_EMP,
			E.CD_USU,
			UPPER(F.NM_FABRIC) NM_FABRIC
            ,l.DS_ARV_MERC_LINHA
            ,S.DS_SIGLA
            ,E.QTDE_PROD
            ,E.VLR_PROD
            ,E.VLR_PROD * (CASE
            WHEN ISNULL(E.PERC_DESC, 0) > 0 THEN ISNULL(E.PERC_DESC, 0)
            ELSE ISNULL(P.PERC_DESC_FABRICA, 0)
            END ) / 100 as VLR_DESC
            ,ROUND(CASE WHEN COALESCE(E.MEDIAF,0) > 0 THEN
              (E.QT_EST_PEND + E.QTDE_PROD) * 30 / E.MEDIAF
            ELSE
              (E.QT_EST_PEND + E.QTDE_PROD) * 30 / 0.0001
            END, 3) COB

      FROM   EST_PROD_SUPRIMENTO_ENTREGA_LOJA E
          INNER JOIN EST_PROD P
              ON E.CD_EMP = P.CD_EMP
                AND E.CD_PROD = P.CD_PROD
          INNER JOIN EST_PROD_FABRIC F
              ON P.CD_FABRIC = F.CD_FABRIC
          INNER JOIN EST_PROD_CURVA_SIGLA S
              ON E.CD_SIGLA = S.CD_SIGLA
          INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA A
              ON P.CD_EMP = A.CD_EMP
                AND P.CD_PROD = A.CD_PROD
          INNER JOIN  EST_ARV_MERC_LINHA l
              ON a.CD_EMP = l.CD_EMP
                AND a.CD_ARV_MERC_LINHA = l.CD_ARV_MERC_LINHA
    ) T
    GROUP BY 
		DS_SIGLA,
		CD_EMP,
		CD_USU
